<?php
/**
 * 标签
 */
class Tags_Controller extends Base_Controller {
	
	
	public function __construct() {
		parent::__construct();
	}
	
	public function index() {	
		$this->assignData();
		$tag = Ext_Filter::sqlChars($this->input->getTrim('tag'));
		$p = $this->input->getIntval('p');
		if (!$tag) {
			show_msg('标签不能为空');	
		}
		$modArticle = load_model('Article');
		$totalNum = $modArticle->getTagsTotal($tag);
		$url = url('Tags', '', array('tag' => $tag, 'p' => '@'));
		$pageInfo = new Ext_Page($url, $totalNum, $p, Wee::$config['web_list_pagenum'], Wee::$config['web_list_pagesnum']);
		$list = $modArticle->getTagsArticle($tag, $pageInfo->limit());
		
		$title = $tag;
		$this->output->set('title', $title);
		$this->output->set('list', $list);
		$this->output->set('tag', $tag);
		$this->output->set('totalNum', $totalNum);
		$this->output->set('pageHtml', $pageInfo->html());
		$this->output->display('tags.dwt');
	}
//图图系统	
	public function all() {	
		$this->assignData();
		$pageshu = Wee::$config['web_list_tagsnum'];
		$p = $this->input->getIntval('p');
		$modArticle = load_model('Article');
		$totalNum = $modArticle->getTagsTotal_All();
		$url = url('tags', 'all', array('p' => '@'));
		$pageInfo = new Ext_Page($url, $totalNum, $p, $pageshu, Wee::$config['web_list_pagesnum']);	
		$modTag = load_model('Tag');
		$list = $modTag->tags($pageInfo->limit());
		$this->output->set('title', '热门标签');
		$this->output->set('list', $list);
		$this->output->set('url', $url);
		$this->output->set('pageshu', $pageshu);
		$this->output->set('totalNum', $totalNum);
		$this->output->set('pageHtml', $pageInfo->html());
		$this->output->display('tags_all.dwt');
	}
	
	public function ad_js() {
		$title = Ext_Filter::sqlChars($this->input->getTrim('title'));
		$str = load_model('Adsense')->getAd($title);
		echo $str;
	}

}